/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.battle_arts.core_assets.skills.weaponinnate;

import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.forixaim.battle_arts.core_assets.animations.AnimationHelpers;
import net.forixaim.battle_arts.core_assets.animations.BattleAnimations;
import net.forixaim.battle_arts.core_assets.skills.BattleArtsDataKeys;
import net.forixaim.battle_arts.initialization.registry.ItemRegistry;
import net.forixaim.battle_arts.initialization.registry.SkillRegistry;
import net.forixaim.battle_arts.initialization.registry.SoundRegistry;
import net.forixaim.bs_api.battle_arts_skills.BattleArtsSkillSlots;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.AttackAnimationProvider;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BlazeStingerSkill
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("9ed5a11f-c7b2-4679-99db-0a4c8de2f5a3");
    private static final AnimationProvider<AttackAnimation> NEUTRAL_SMASH = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_BLAZE_STINGER;
    private static final AnimationProvider<AttackAnimation> DOWN_SMASH = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_DOWN_SMASH;
    private static final AnimationProvider<AttackAnimation> NEUTRAL_AERIAL_SMASH = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_NEUTRAL_HEAVY_AERIAL;
    private static final AnimationProvider<AttackAnimation> SOLAR_FLARE = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_SOLAR_FLARE;
    private final AttackAnimationProvider[] heavyAttacks = new AttackAnimationProvider[]{() -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_BLAZE_STINGER};

    public BlazeStingerSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public static Skill.Builder createBlazeStinger() {
        return new Skill.Builder().setCategory((SkillCategory)SkillCategories.WEAPON_INNATE).setResource(Skill.Resource.STAMINA);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FriendlyByteBuf gatherArguments(LocalPlayerPatch executer, ControllEngine controllEngine) {
        Input input = ((LocalPlayer)executer.getOriginal()).f_108618_;
        float pulse = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)((LivingEntity)executer.getOriginal()))), (float)0.0f, (float)1.0f);
        input.m_214106_(false, pulse);
        int forward = ControllEngine.isKeyDown((KeyMapping)Minecraft.m_91087_().f_91066_.f_92085_) ? 1 : 0;
        int backward = ControllEngine.isKeyDown((KeyMapping)Minecraft.m_91087_().f_91066_.f_92087_) ? -1 : 0;
        int left = ControllEngine.isKeyDown((KeyMapping)Minecraft.m_91087_().f_91066_.f_92086_) ? 1 : 0;
        int right = ControllEngine.isKeyDown((KeyMapping)Minecraft.m_91087_().f_91066_.f_92088_) ? -1 : 0;
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(forward);
        buf.writeInt(backward);
        buf.writeInt(left);
        buf.writeInt(right);
        return buf;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(LocalPlayerPatch executer, FriendlyByteBuf args) {
        int forward = args.readInt();
        int backward = args.readInt();
        int left = args.readInt();
        int right = args.readInt();
        int vertic = forward + backward;
        int horizon = left + right;
        CPExecuteSkill packet = new CPExecuteSkill(executer.getSkill((Skill)this).getSlotId());
        packet.getBuffer().writeInt(Integer.compare(vertic, 0));
        packet.getBuffer().writeInt(Integer.compare(horizon, 0));
        return packet;
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> {
            if (event.getAnimation() == BattleAnimations.IMPERATRICE_SWORD_NEUTRAL_HEAVY_AERIAL || event.getAnimation() == BattleAnimations.IMPERATRICE_SWORD_BLAZE_STINGER || event.getAnimation() == BattleAnimations.IMPERATRICE_SWORD_DOWN_SMASH || event.getAnimation() == BattleAnimations.IMPERATRICE_SWORD_SOLAR_FLARE) {
                container.getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.CHARGE_EXECUTING.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.CHARGE_EXECUTING.get())).booleanValue()) {
                container.getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.CHARGE_EXECUTING.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_HURT, EVENT_UUID, event -> {
            if (event.getDamageSource().getAnimation() == BattleAnimations.IMPERATRICE_SWORD_DOWN_SMASH && EpicFightCapabilities.getEntityPatch((Entity)event.getTarget(), LivingEntityPatch.class) != null) {
                ((LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)event.getTarget(), LivingEntityPatch.class)).knockBackEntity(event.getTarget().m_20318_(0.0f), 1000.0f);
            }
            if (event.getDamageSource().getAnimation() == BattleAnimations.IMPERATRICE_SWORD_BLAZE_STINGER) {
                ValueModifier damageModifier = ValueModifier.empty();
                this.getProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Map)this.properties.get(0)).ifPresent(arg_0 -> ((ValueModifier)damageModifier).merge(arg_0));
                damageModifier.merge(ValueModifier.multiplier((float)0.8f));
                if (((Player)container.getExecuter().getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ItemRegistry.ORIGIN_JOYEUSE.get())) {
                    event.getTarget().m_7311_(event.getTarget().m_20094_() + 20);
                }
                if ((event.getTarget().m_21023_(MobEffects.f_19606_) || event.getTarget().m_21023_(MobEffects.f_19607_)) && ThreadLocalRandom.current().nextInt(0, 4) == 1) {
                    if (event.getTarget().m_21023_(MobEffects.f_19606_)) {
                        int duration = Objects.requireNonNull(event.getTarget().m_21124_(MobEffects.f_19606_)).m_19557_();
                        int potency = Objects.requireNonNull(event.getTarget().m_21124_(MobEffects.f_19606_)).m_19564_() - 1;
                        event.getTarget().m_21195_(MobEffects.f_19606_);
                        if (potency >= 0) {
                            event.getTarget().m_7292_(new MobEffectInstance(MobEffects.f_19606_, duration, potency));
                        }
                    }
                    event.getDamageSource().addRuntimeTag(DamageTypeTags.f_268413_);
                    event.getDamageSource().addRuntimeTag(DamageTypeTags.f_268490_);
                    event.getTarget().m_21195_(MobEffects.f_19607_);
                    ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)SoundRegistry.CRITICAL_HIT.get(), 0.0f, 0.0f);
                }
            }
        });
    }

    public boolean canExecute(PlayerPatch<?> executor) {
        if (executor.isLogicalClient()) {
            return super.canExecute(executor);
        }
        ItemStack itemstack = ((Player)executor.getOriginal()).m_21120_(InteractionHand.MAIN_HAND);
        if (AnimationHelpers.isInAir(executor)) {
            return EpicFightCapabilities.getItemStackCapability((ItemStack)itemstack).getInnateSkill(executor, itemstack) == this && executor.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().hasData((SkillDataKey)BattleArtsDataKeys.ULTIMATE_ART_ACTIVE.get()) && (Boolean)executor.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.ULTIMATE_ART_ACTIVE.get()) == false && (Boolean)executor.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.CHARGE_EXECUTING.get()) == false && (Boolean)executor.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.CHARGE_AERIAL.get()) == false;
        }
        return EpicFightCapabilities.getItemStackCapability((ItemStack)itemstack).getInnateSkill(executor, itemstack) == this && executor.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().hasData((SkillDataKey)BattleArtsDataKeys.ULTIMATE_ART_ACTIVE.get()) && (Boolean)executor.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.ULTIMATE_ART_ACTIVE.get()) == false && (Boolean)executor.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.CHARGE_EXECUTING.get()) == false;
    }

    public void executeOnServer(ServerPlayerPatch executor, FriendlyByteBuf args) {
        int fw = args.readInt();
        int sw = args.readInt();
        executor.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.CHARGE_EXECUTING.get(), (Object)true, (ServerPlayer)executor.getOriginal());
        if (executor.getSkill((SkillSlot)SkillSlots.BASIC_ATTACK).hasSkill(SkillRegistry.IMPERATRICE_ATTACK) && executor.getSkill((SkillSlot)SkillSlots.BASIC_ATTACK).getDataManager().hasData((SkillDataKey)BattleArtsDataKeys.BLAZE_COMBO.get())) {
            executor.getSkill((SkillSlot)SkillSlots.BASIC_ATTACK).getDataManager().setData((SkillDataKey)BattleArtsDataKeys.BLAZE_COMBO.get(), (Object)0);
        }
        if (AnimationHelpers.isInAir(executor)) {
            executor.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.CHARGE_AERIAL.get(), (Object)true, (ServerPlayer)executor.getOriginal());
            executor.playAnimationSynchronized(NEUTRAL_AERIAL_SMASH.get(), 0.0f);
        } else if (fw == 1) {
            executor.playAnimationSynchronized(SOLAR_FLARE.get(), 0.0f);
        } else if (((ServerPlayer)executor.getOriginal()).m_6144_()) {
            executor.playAnimationSynchronized(DOWN_SMASH.get(), 0.0f);
        } else {
            executor.playAnimationSynchronized(NEUTRAL_SMASH.get(), 0.0f);
        }
        super.executeOnServer(executor, args);
    }

    public void onRemoved(SkillContainer container) {
        PlayerEventListener eventListener = container.getExecuter().getEventListener();
        eventListener.removeListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
        eventListener.removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
        eventListener.removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_HURT, EVENT_UUID);
    }

    public void updateContainer(SkillContainer container) {
        if (!AnimationHelpers.isInAir(container.getExecuter()) && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.CHARGE_AERIAL.get())).booleanValue() && !container.getExecuter().isLogicalClient()) {
            container.getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.CHARGE_AERIAL.get(), (Object)false, (ServerPlayer)container.getExecuter().getOriginal());
        }
    }
}

